<?php
# KONFIGUARTION EINBINDEN
include ("inc/konfiguration.php");
?>
<!DOCTYPE html>
<html lang="de">
	<head>
		<!-- Meta -->
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<!-- CSS -->
		<link rel="stylesheet" href="css/default.css" />
		<!-- Title -->
		<title>DEMO | pkwliste.com</title>
		<!-- Favicons -->
		<link rel="apple-touch-icon" sizes="180x180" href="img/favicon/apple-touch-icon.png" />
		<link rel="icon" type="image/png" sizes="32x32" href="img/favicon/favicon-32x32.png" />
		<link rel="icon" type="image/png" sizes="16x16" href="img/favicon/favicon-16x16.png" />
		<link rel="shortcut icon" href="img/favicon/favicon.ico" />
	</head>
	<body>
		<div class="main-content">
			<header class="main-header">
				<div class="container">
					<div class="header-container">
						<div class="header-logo">
							<a title="pkwliste.com" href="index.php">
								<img alt="PKW Liste" title="PKW Liste" class="img-responsive" src="img/logo/logo.png" />
							</a>
						</div>
						<div class="link-list hidden-sm hidden-xs">
							<div class="links">
								<a class="link" title="Jetzt kaufen" href="https://www.pkwliste.com" target="_blank">
									Jetzt kaufen
								</a>
							</div>
						</div>
					</div>
				</div>
			</header>
			<div class="container">
				<div class="main-container">
					<div class="main-banner-image-container grid-item">						
						<div class="main-banner-image-content">
							<div class="background"></div>
						</div>
					</div>
					<div class="main-pkwliste-container grid-item">
						<div class="pkwliste">
							<div class="demo">Demo</div>
							<div class="infobox">
								<strong class="info-text">Demo Datenbank</strong>
								<div class="info-beschreibung">
									<span>
										Hier haben Sie die Möglichkeit anhand einer Fahrzeugsuche (Demo) unsere Datenbank zu testen.
									</span>
								</div>
							</div>
							<div class="">
								<ul class="nav nav-tabs" role="tablist">
									<li role="presentation" class="active">
										<a id="tab_l_1" href="#pkw_suche" aria-controls="pkw_suche" role="tab" data-toggle="tab">
											Fahrzeugsuche
										</a>
									</li>
									<li role="presentation">
										<a id="tab_l_2" href="#pkw_hsn_tsn" aria-controls="pkw_hsn_tsn" role="tab" data-toggle="tab">
											HSN / TSN
										</a>
									</li>
								</ul>
							</div>
							<div class="suche-tab">
								<div class="tab-content">
									<div role="tabpanel" class="tab-pane active" id="pkw_suche">
										<div id="sft" class="suchfeld">
											<input class="pkwliste_suche_inp hersteller" placeholder="Hersteller" type="text" />
											<i class="fa fa-search" aria-hidden="true"></i>
										</div>
										<div id="sawl" class="schnellauswahl clearfix">
											<button class="top-5" data-hid="7" title="VW">
												<img class="logo" src="img/pkwliste/hersteller/7.png" alt="VW" />
											</button>
											<button class="top-5" data-hid="1" title="Audi">
												<img class="logo" src="img/pkwliste/hersteller/1.png" alt="Audi" />
											</button>
											<button class="top-5" data-hid="5" title="Opel">
												<img class="logo" src="img/pkwliste/hersteller/5.png" alt="Opel" />
											</button>
											<button class="top-5" data-hid="2" title="BMW">
												<img class="logo" src="img/pkwliste/hersteller/2.png" alt="BMW" />
											</button>
											<button class="top-5" data-hid="4" title="Mercedes-Benz">
												<img class="logo" src="img/pkwliste/hersteller/4.png" alt="Mercedes-Benz" />
											</button>
										</div>
										<div id="aswn" class="auswahl-nav clearfix">
											<a id="go_back_an" class="zurueck">
												<i class="fa fa-chevron-left" aria-hidden="true"></i>
												<span>Zurück</span>
											</a>
										</div>
										<div class="option-box">
											<ol id="herst_ol_list" class="h_ol_li"></ol>
											<ol id="baureihen_ol_list" class="b_ol_li"></ol>
											<ol id="generation_ol_list" class="g_ol_li"></ol>
										</div>
									</div>
									<div role="tabpanel" class="tab-pane hsn-tsn-info" id="pkw_hsn_tsn">
										<div id="hsn_tsn_form">
											<form id="go_to_hsn_tsn" class="" action="fahrzeug.php" method="post">
												<b>Schlüsselnummer eingeben:</b>
												<p>
													Die HSN (Herstellerschlüsselnummer) und TSN 
													(Typschlüsselnummer) finden Sie in der neuen 
													Zulassungsbescheinigung unter Position 2.1 und 2.2
													oder in Ihrem Fahrzeugschein unter Position 2 und 3.
													<br /><br />
													Beispielsuche: HSN: 7967, TSN: AAH
												</p>
												<div class="row">
													<div class="col-xs-6 hsn-input form-group">
														<label class="hsn-label" for="hsn_tab">
															HSN
															(4-stellig)
														</label>
														<input type="text" name="hsn" id="hsntab" maxlength="4" class="input-hsn-tsn" placeholder="HSN" />
													</div>
													<div class="col-xs-6 tsn-input form-group">
														<label class="tsn-label" for="tsn-tab">
															TSN
															(3-stellig)
														</label>
														<input type="text" name="tsn" id="tsntab" maxlength="3" class="input-hsn-tsn" placeholder="TSN" />
													</div>
													<div id="pkw_e_hsn_tsn" class="hsn_tsn_error"></div>
												</div>
												<button type="submit" class="btn btn-danger btn-block">
													Fahrzeug wählen
												</button>
											</form>
										</div>
										<div class="row hsn-tsn-image-container">
											<div class="col-xs-12">
												<p class="def">Zulassungsbescheinigung Teil 1 (ab 01.10.2005)</p>
												<img alt="Hier finden Sie die Herstellerschlüsselnummer in Ihren Fahrzeugpapieren." title="Hier finden Sie die Schlüsselnummer in Ihrer Zulassungsbescheinigung Teil 1." src="img/pkwliste/extras/hsn-tsn.jpg" />
											</div>
											<div class="col-xs-12">
												<p class="def">Fahrzeugschein (bis 30.09.2005)</p>
												<img alt="Hier finden Sie die Typschlüsselnummer in Ihren Fahrzeugpapieren." title="Hier finden Sie die Schlüsselnummer in Ihrem Fahrzeugschein." src="img/pkwliste/extras/tsn-hsn-alt.jpg" />
											</div>
										</div>
									</div>
								</div>
							</div>
							<div id="ajax_erg_ml" class="ergebnisse clearfix">
								<aside class="col-lg-3 col-md-3 col-sd-4 col-xs-12 ">
									<div class="pkw-info-daten">
										<div class="pkw-info-box-links">
											<p>Hersteller:</p>
											<img id="erg_hb" src="" alt="" />
										</div>
										
										<div class="pkw-info-box-links">
											<p>Modell:</p>
											<span id="erg_mt"></span>
										</div>
									</div>
									<button id="erg_s_z" type="button" class="btn pull-left schritt-zurueck">
										<i class="fa fa-caret-left" aria-hidden="true"></i> Zurück
									</button>
								</aside>
								<div class="col-md-9 col-xs-12">
									<div class="modell-waehlen clearfix">
										<p class="pull-left">
											Fahrzeug wählen:
										</p>
									</div>
									<div class="modell-waehlen-suche clearfix">
										<input id="pkw_modellwahl" type="text" value="" placeholder="Suche..." />
									</div>
									<form id="go_to_fahrz" action="fahrzeug.php" method="GET">
										<input type="hidden" name="fahrz_id" id="fid" value="" />
										<div class="ergebnisse-tabelle-wrapper">
										<table class="ergebnisse-tabelle">
											<thead>
												<tr>
													<th>&nbsp;</th>
													<th>
														Fahrzeug
													</th>
													<th>
														Typ
													</th>
													<th>
														Kraftstoff
													</th>
													<th>
														Leistung
													</th>
													<th class="hidden-xs">
														Hubraum
													</th>
													<th>
														Baujahr
													</th>
												</tr>
											</thead>
											<tbody id="ajax_ml"></tbody>
										</table>
										</div>
										<div class="fehlermeldung pull-right"><i class="icon-warning-sign"></i> Bitte wählen Sie zuerst ein Fahrzeug aus</div>
										<button class="btn btn-danger pull-right fahrzeug-waehlen" type="submit" value="Ergebnisse anzeigen">
											<i class="fa fa-caret-right pull-right" aria-hidden="true"></i> Fahrzeug auswählen
										</button>
									</form>           
								</div>
							</div>
						</div>
					</div>
					<div class="main-angebot-container grid-item">
						<div class="angebotsliste static-liste">
							<div class="aliste-outer">
								<div class="aliste-main">
									<div class="aliste-item active">
										<a class="grid-container" href="https://www.pkwliste.com" target="_blank" title="Weitere Informationen zur PKW Datenbank">
											<div class="item-text">
												<p class="eins">Die PKW Datenbank</p>
												<p class="zwei">zur Einbindung auf Ihrer Webseite</p>
												<p class="drei">Weitere Informationen</p>
												<p class="vier">erhalten Sie hier</p>
											</div>
											<div class="item-preis">
												<span class="ab">schon ab</span>
												<span class="preis">349,00 €</span>
											</div>
											<div class="item-info">
												<div class="mehr-infos">
													<span class="text">Jetzt kaufen</span>
													<span class="pfeil">
														<i class="fa fa-caret-right" aria-hidden="true"></i>
													</span>
												</div>
											</div>
											<div class="item-bilder">
												<div class="bild-1">
													<img alt="SQL Daten" class="aliste-bild" src="img/intro-produkt/pkwliste-laptop-sql.png" />
												</div>
												<div class="bild-2">
													<img alt="Produkt" class="aliste-bild" src="img/intro-produkt/pkwliste-software-sql.png" />
												</div>
											</div>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="container">
				<hr class="banner-horizontal-line">
				<div class="row">
					<div class="col-md-12 col-xs-12">
						<p>
							&copy; <?php echo date("Y"); ?> pkwliste.com
						</p>
					</div>
				</div>
			</div>
		</div>		
		<script src="js/default.js"></script>
		<script src="js/pkwliste.js"></script>
	</body>
</html>